package com.elitesland.cbpl.sns.inbox.util;

import com.elitesland.cbpl.sns.common.domain.SnsPayload;
import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.sns.inbox.service.InboxService;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import lombok.extern.slf4j.Slf4j;

import java.util.Set;

/**
 * @author eric.hao
 * @since 2024/12/19
 */
@Slf4j
public class InboxUtil {

    /**
     * 发送站内信
     *
     * @param inboxType 站内信类型
     * @param tos       接收人userIds
     * @param payload   邮件内容
     */
    public static void sendInbox(InboxType inboxType, Set<String> tos, SnsPayload payload) {
        InboxService inboxService = SpringUtils.getBean(InboxService.class);
        inboxService.sendInbox(inboxType, tos, payload);
    }
}
