package com.elitesland.cbpl.sns.inbox.vo.param;

import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.tool.db.PageQueryParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.time.LocalDateTime;

/**
 * @author eric.hao
 * @since 2024/12/19
 */
@ApiModel("站内消息查询条件")
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class InboxPageParamVO extends PageQueryParam {

    private static final long serialVersionUID = 341908981780840655L;

    @ApiModelProperty("消息分类")
    private InboxType type = InboxType.INBOX_TODO;

    @ApiModelProperty("收信人ID")
    @JsonIgnore
    private String recipientId;

    @ApiModelProperty("消息类型")
    private String msgType;

    @ApiModelProperty("从...开始(包含)")
    private LocalDateTime sinceTime;

    @ApiModelProperty("到...为止(包含)")
    private LocalDateTime untilTime;

    @ApiModelProperty("true:未读|false:已读|null:全部")
    private Boolean unread;

    @ApiModelProperty("查询结果是否仅给出概要信息？")
    private boolean outline;

    @ApiModelProperty("主题模糊查询")
    private String subject;

    @ApiModelProperty("是否是微信发起？")
    private Boolean wechat;
}
