package com.elitesland.cbpl.sns.inbox.vo.save;

import com.elitesland.cbpl.sns.inbox.domain.InboxPayload;
import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Builder;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

/**
 * @author eric.hao
 * @since 2024/12/19
 */
@Data
@Builder
public class InboxSaveParamVO implements InboxPayload {

    private static final long serialVersionUID = 4462505178076309087L;

    /**
     * 事件ID
     */
    @Id
    private String id;

    /**
     * 生成时间
     */
    private LocalDateTime createTime;

    @Override
    public LocalDateTime getTime() {
        return createTime;
    }

    /**
     * 类型
     */
    private InboxType type;

    /**
     * 标题
     */
    private String subject;

    /**
     * 内容
     */
    private String content;

    /**
     * 发信人ID
     */
    private String from;

    private String fromName;

    /**
     * 收信人ID集
     */
    private Set<String> tos;

    private String toNames;

    /**
     * 扩展信息(注意保持写入与读取的类型一致性)
     */
    private Object extInfo;

    /**
     * 已读时间(所有收件人)
     */
    @Builder.Default
    @JsonIgnore
    private Map<String, LocalDateTime> read = Collections.emptyMap();

    /**
     * 已读时间(指定收件人)
     */
    private LocalDateTime readTime;
}
