/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.sns.common.domain;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class SnsPayload {
    @NonNull
    private String subject;
    @NonNull
    private String content;

    public static SnsPayload empty() {
        return SnsPayload.of("", "");
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.subject) && StringUtils.isNotBlank((CharSequence)this.content);
    }

    @NonNull
    public String getSubject() {
        return this.subject;
    }

    @NonNull
    public String getContent() {
        return this.content;
    }

    public void setSubject(@NonNull String subject) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        this.subject = subject;
    }

    public void setContent(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnsPayload)) {
            return false;
        }
        SnsPayload other = (SnsPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SnsPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "SnsPayload(subject=" + this.getSubject() + ", content=" + this.getContent() + ")";
    }

    private SnsPayload(@NonNull String subject, @NonNull String content) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.subject = subject;
        this.content = content;
    }

    public static SnsPayload of(@NonNull String subject, @NonNull String content) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return new SnsPayload(subject, content);
    }
}

