/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.sns.inbox.controller;

import com.elitesland.cbpl.sns.inbox.config.SnsInboxProperties;
import com.elitesland.cbpl.sns.inbox.domain.InboxPayload;
import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.sns.inbox.pipeline.InboxPipeline;
import com.elitesland.cbpl.sns.inbox.vo.param.InboxPageParamVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.tool.iam.IamSpiUtil;
import com.elitesland.cbpl.unicom.util.UnicomClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d88\u606f\u6570\u636e\u670d\u52a1"})
@RestController
@RequestMapping(value={"/sns/inbox"})
public class InboxController {
    private static final Logger logger = LoggerFactory.getLogger(InboxController.class);
    private final InboxPipeline inboxPipeline;

    @ApiOperation(value="\u672a\u8bfb\u6d88\u606f\u6570\u91cf")
    @GetMapping(value={"/count"})
    public Map<InboxType, Long> countUnread() {
        return (Map)UnicomClient.supply(() -> this.inboxPipeline.countUnread(IamSpiUtil.currentUserIdStr(), InboxType.getStoreTypes()), (String)SnsInboxProperties.SNS_INBOX_PIPELINE);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/paging"})
    public PagingVO<? extends InboxPayload> find(@RequestBody InboxPageParamVO query) {
        if (query.getRecipientId() == null) {
            query.setRecipientId(IamSpiUtil.currentUserIdStr());
        }
        return (PagingVO)UnicomClient.supply(() -> this.inboxPipeline.find(query), (String)SnsInboxProperties.SNS_INBOX_PIPELINE);
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @PatchMapping(value={"/{type}/messages/{id}"})
    public Optional<? extends InboxPayload> read(@PathVariable InboxType type, @PathVariable(value="id") String messageId) {
        return (Optional)UnicomClient.supply(() -> this.inboxPipeline.read(type, messageId, IamSpiUtil.currentUserIdStr()), (String)SnsInboxProperties.SNS_INBOX_PIPELINE);
    }

    @ApiOperation(value="\u5168\u90e8\u5df2\u8bfb")
    @PatchMapping(value={"/{type}/allMessages"})
    public HttpResult<Void> readAllMessages(@PathVariable InboxType type) {
        UnicomClient.run(() -> this.inboxPipeline.readAllMessages(type, IamSpiUtil.currentUserIdStr()), (String)SnsInboxProperties.SNS_INBOX_PIPELINE);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u6d88\u606f\u7c7b\u578b\u4e0b\u62c9")
    @PostMapping(value={"/msgType"})
    public HttpResult<List<Map<String, String>>> getMsgType() {
        return HttpResult.ok((Object)((List)UnicomClient.supply(this.inboxPipeline::getMsgType, (String)SnsInboxProperties.SNS_INBOX_PIPELINE)));
    }

    public InboxController(InboxPipeline inboxPipeline) {
        this.inboxPipeline = inboxPipeline;
    }
}

