/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.sns.inbox.pipeline.mongo.query;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.sns.inbox.vo.param.InboxPageParamVO;
import com.elitesland.cbpl.tool.db.OrderItem;
import com.elitesland.cbpl.tool.mongo.repository.MongoQuery;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public class InboxPageQuery
extends MongoQuery {
    private static final Logger logger = LoggerFactory.getLogger(InboxPageQuery.class);
    private final InboxPageParamVO params;

    public String getStoreName() {
        return this.params.getType().getStoreName();
    }

    public InboxPageQuery(InboxPageParamVO params) {
        OrderItem order = new OrderItem();
        order.setAsc(false);
        order.setColumn("_id");
        super.setOrders(List.of(order));
        super.setCurrent(params.getCurrent());
        super.setSize(params.getSize());
        this.params = params;
    }

    private void addRecipientsCriteria(Query query) {
        query.fields().exclude("tos");
        query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"tos").size(0), Criteria.where((String)"tos").is((Object)this.params.getRecipientId())}));
    }

    private void addCreateTimeCriteria(Query query) {
        LocalDateTime sinceTime = this.params.getSinceTime();
        LocalDateTime untilTime = this.params.getUntilTime();
        if (sinceTime != null || untilTime != null) {
            Criteria filter = Criteria.where((String)"createTime");
            if (sinceTime != null) {
                filter.gte((Object)sinceTime);
            }
            if (untilTime != null) {
                filter.lt((Object)untilTime);
            }
            query.addCriteria((CriteriaDefinition)filter);
        }
    }

    private void addReadTimesCriteria(Query query) {
        if (this.params.getUnread() != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)("read." + this.params.getRecipientId())).exists(this.params.getUnread() == false));
        }
    }

    private void withFields(Query query) {
        if (this.params.isOutline()) {
            query.fields().exclude("payload.content");
        }
    }

    private void addMsgType(Query query) {
        if (this.params.getMsgType() != null && StrUtil.isNotBlank((CharSequence)this.params.getMsgType())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"extInfo.eventType").in(new Object[]{this.params.getMsgType()}));
        }
    }

    private void addSubject(Query query) {
        String subject = this.params.getSubject();
        if (StringUtils.hasText((String)subject)) {
            String regex = "^.*" + subject + ".*$";
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"subject").regex(regex));
        }
    }

    protected Query buildQuery() {
        Query query = new Query();
        this.addRecipientsCriteria(query);
        this.addCreateTimeCriteria(query);
        this.addReadTimesCriteria(query);
        this.addSubject(query);
        this.withFields(query);
        this.addMsgType(query);
        logger.info("[SNS-INBOX] query: {}", (Object)query);
        return query;
    }

    public static InboxPageQueryBuilder builder() {
        return new InboxPageQueryBuilder();
    }

    public String toString() {
        return "InboxPageQuery(params=" + this.params + ")";
    }

    public static class InboxPageQueryBuilder {
        private InboxPageParamVO params;

        InboxPageQueryBuilder() {
        }

        public InboxPageQueryBuilder params(InboxPageParamVO params) {
            this.params = params;
            return this;
        }

        public InboxPageQuery build() {
            return new InboxPageQuery(this.params);
        }

        public String toString() {
            return "InboxPageQuery.InboxPageQueryBuilder(params=" + this.params + ")";
        }
    }
}

