/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.sns.inbox.pipeline.mongo.query;

import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.tool.mongo.repository.MongoQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class InboxUnreadQuery
extends MongoQuery {
    private static final Logger logger = LoggerFactory.getLogger(InboxUnreadQuery.class);
    private InboxType type;
    private String reader;

    public String getStoreName() {
        return this.type.getStoreName();
    }

    private void addRecipientsCriteria(Query query) {
        query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"tos").size(0), Criteria.where((String)"tos").is((Object)this.reader)}));
    }

    private void addReadTimesCriteria(Query query) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)("read." + this.reader)).exists(false));
    }

    protected Query buildQuery() {
        Query query = new Query();
        this.addRecipientsCriteria(query);
        this.addReadTimesCriteria(query);
        logger.debug("[SNS-INBOX] query: {}", (Object)query);
        return query;
    }

    InboxUnreadQuery(InboxType type, String reader) {
        this.type = type;
        this.reader = reader;
    }

    public static InboxUnreadQueryBuilder builder() {
        return new InboxUnreadQueryBuilder();
    }

    public String toString() {
        return "InboxUnreadQuery(type=" + this.type + ", reader=" + this.reader + ")";
    }

    public static class InboxUnreadQueryBuilder {
        private InboxType type;
        private String reader;

        InboxUnreadQueryBuilder() {
        }

        public InboxUnreadQueryBuilder type(InboxType type) {
            this.type = type;
            return this;
        }

        public InboxUnreadQueryBuilder reader(String reader) {
            this.reader = reader;
            return this;
        }

        public InboxUnreadQuery build() {
            return new InboxUnreadQuery(this.type, this.reader);
        }

        public String toString() {
            return "InboxUnreadQuery.InboxUnreadQueryBuilder(type=" + this.type + ", reader=" + this.reader + ")";
        }
    }
}

