/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.sns.inbox.pipeline.mongo.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.elitesland.cbpl.sns.inbox.domain.InboxPayload;
import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.sns.inbox.pipeline.InboxPipeline;
import com.elitesland.cbpl.sns.inbox.pipeline.mongo.query.InboxPageQuery;
import com.elitesland.cbpl.sns.inbox.pipeline.mongo.query.InboxUnreadQuery;
import com.elitesland.cbpl.sns.inbox.vo.param.InboxPageParamVO;
import com.elitesland.cbpl.sns.inbox.vo.resp.InboxRespVO;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.tool.mongo.domain.MongoDoc;
import com.elitesland.cbpl.tool.mongo.repository.MongoStorer;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="MONGO")
public class InboxMongoService
implements InboxPipeline {
    private static final Logger logger = LoggerFactory.getLogger(InboxMongoService.class);
    private static final String ERR_MONGO_CONFIGURATION = "[SNS-INBOX] MongoDB Incorrect configuration.";
    @Autowired(required=false)
    private MongoStorer mongoStorer;
    @Autowired(required=false)
    private MongoTemplate mongoTemplate;

    private Class<InboxRespVO> getEntityClass() {
        return InboxRespVO.class;
    }

    @Override
    public void save(InboxPayload payload) {
        if (this.mongoStorer == null) {
            logger.error(ERR_MONGO_CONFIGURATION);
            return;
        }
        try {
            this.mongoStorer.save((MongoDoc)payload);
        }
        catch (Throwable throwable) {
            logger.error("[SNS-INBOX] persistence mongodb error", throwable);
        }
    }

    @Override
    public Map<InboxType, Long> countUnread(String reader, Stream<InboxType> types) {
        if (this.mongoStorer == null) {
            logger.error(ERR_MONGO_CONFIGURATION);
            return MapUtil.empty();
        }
        return types.collect(Collectors.toMap(type -> type, type -> InboxUnreadQuery.builder().type((InboxType)((Object)type)).reader(reader).build().count(this.mongoTemplate)));
    }

    @Override
    public PagingVO<? extends InboxPayload> find(InboxPageParamVO params) {
        if (this.mongoStorer == null) {
            logger.error(ERR_MONGO_CONFIGURATION);
            return new PagingVO();
        }
        PagingVO result = InboxPageQuery.builder().params(params).build().paging(this.mongoTemplate, this.getEntityClass());
        if (result.getTotal() > 0L) {
            List records = result.getRecords();
            records.forEach(record -> record.setReadFlag(!record.getRead().isEmpty() && record.getRead().containsKey(params.getRecipientId())));
        }
        return result;
    }

    @Override
    public Optional<? extends InboxPayload> read(InboxType type, String messageId, String reader) {
        if (this.mongoStorer == null) {
            logger.error(ERR_MONGO_CONFIGURATION);
            return Optional.empty();
        }
        InboxRespVO message = (InboxRespVO)this.mongoTemplate.findById((Object)messageId, this.getEntityClass(), type.getStoreName());
        if (message == null) {
            return Optional.empty();
        }
        Update update = Update.update((String)("read." + reader), (Object)Instant.now());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)messageId).orOperator(new Criteria[]{Criteria.where((String)"tos").size(0), Criteria.where((String)"tos").is((Object)reader)}));
        this.mongoTemplate.findAndModify(query, (UpdateDefinition)update, this.getEntityClass(), type.getStoreName());
        return Optional.of(message);
    }

    @Override
    public void readAllMessages(InboxType type, String reader) {
        if (this.mongoStorer == null) {
            logger.error(ERR_MONGO_CONFIGURATION);
            return;
        }
        Update update = Update.update((String)("read." + reader), (Object)Instant.now());
        Query query = Query.query((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"tos").size(0), Criteria.where((String)"tos").is((Object)reader)}));
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, this.getEntityClass(), type.getStoreName());
    }

    @Override
    public List<Map<String, String>> getMsgType() {
        if (this.mongoStorer == null) {
            logger.error(ERR_MONGO_CONFIGURATION);
            return ListUtil.empty();
        }
        return ListUtil.empty();
    }
}

