/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.sns.inbox.service;

import com.elitesland.cbpl.sns.common.domain.SnsPayload;
import com.elitesland.cbpl.sns.inbox.config.SnsInboxProperties;
import com.elitesland.cbpl.sns.inbox.domain.InboxPayload;
import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.sns.inbox.pipeline.InboxPipeline;
import com.elitesland.cbpl.sns.inbox.service.InboxService;
import com.elitesland.cbpl.sns.inbox.vo.save.InboxSaveParamVO;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import com.elitesland.cbpl.tool.websocket.notifier.WebSocketNotifier;
import com.elitesland.cbpl.tool.websocket.notifier.domain.NotifierPayload;
import com.elitesland.cbpl.unicom.util.UnicomClient;
import java.time.LocalDateTime;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InboxServiceImpl
implements InboxService {
    private static final Logger logger = LoggerFactory.getLogger(InboxServiceImpl.class);
    private final InboxPipeline inboxPipeline;

    @Override
    public void sendInbox(InboxType inboxType, Set<String> tos, SnsPayload payload) {
        if (!payload.isValid()) {
            logger.info("[SNS-INBOX] INBOX message payload is empty.");
            return;
        }
        try {
            logger.info("[SNS-INBOX] INBOX message to userId={} sending...", tos);
            InboxSaveParamVO inboxPayload = InboxSaveParamVO.builder().createTime(LocalDateTime.now()).type(inboxType).subject(payload.getSubject()).content(payload.getContent()).from("1").tos(tos).build();
            logger.info("[SNS-INBOX] INBOX payload: {}", (Object)inboxPayload);
            this.push(inboxPayload);
            logger.info("[SNS-INBOX] INBOX message SENT.");
        }
        catch (Throwable e) {
            logger.error("[SNS-INBOX] INBOX message sent FAILED.", e);
        }
    }

    private void push(InboxPayload payload) {
        UnicomClient.run(() -> this.inboxPipeline.save(payload), (String)SnsInboxProperties.SNS_INBOX_PIPELINE);
        if (SpringUtils.isPresent(WebSocketNotifier.class)) {
            WebSocketNotifier notifier = (WebSocketNotifier)SpringUtils.getBean(WebSocketNotifier.class);
            notifier.notify((NotifierPayload)payload);
        } else {
            logger.warn("[SNS-INBOX] WebSocketNotifier closed.");
        }
    }

    public InboxServiceImpl(InboxPipeline inboxPipeline) {
        this.inboxPipeline = inboxPipeline;
    }
}

