package com.elitesland.cbpl.unicom.adapter;

import com.elitesland.cbpl.unicom.util.UnicomAdapterUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Optional;

/**
 * @author eric.hao
 * @since 2023/04/25
 */
@Slf4j
public class DefaultUnicomAdapter implements UnicomAdapter {

    @Override
    public Object filter(List<Object> providers) {
        for (Object row : providers) {
            logger.debug("[PHOENIX-UNICOM] load impl className({})", row.getClass().getSimpleName());
        }
        // 1.优先执行定开版本代码
        Optional<Object> customerProvider = UnicomAdapterUtil.matchCustomize(providers);
        if (customerProvider.isPresent()) {
            logger.debug("[PHOENIX-UNICOM] context provider: {}", customerProvider.getClass().getSimpleName());
            return customerProvider.get();
        }
        // 2.其次任一执行个实现类
        Object provider = providers.get(0);
        logger.debug("[PHOENIX-UNICOM] execute impl className({})", providers.get(0).getClass().getSimpleName());
        return provider;
    }
}
