/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.config;

import com.elitesland.cbpl.unicom.adapter.DefaultUnicomAdapter;
import com.elitesland.cbpl.unicom.config.UnicomProperties;
import com.elitesland.cbpl.unicom.proxy.UnicomAdapterProxy;
import com.elitesland.cbpl.unicom.proxy.UnicomAdapterProxyFactoryBean;
import com.elitesland.cbpl.unicom.proxy.UnicomInterfaceProxy;
import com.elitesland.cbpl.unicom.proxy.UnicomInterfaceProxyFactoryBean;
import com.elitesland.cbpl.unicom.register.ProxyBeanDefinitionRegister;
import java.util.ArrayList;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={UnicomProperties.class})
@ConditionalOnProperty(prefix="cbpl.unicom", name={"enabled"}, havingValue="true")
public class UnicomConfig
implements EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(UnicomConfig.class);
    private UnicomProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public Reflections reflections() {
        logger.info("[PHOENIX-UNICOM] loading reflections.");
        ArrayList urls = new ArrayList();
        for (String basePackage : this.properties.getBasePackage()) {
            urls.addAll(ClasspathHelper.forPackage((String)basePackage, (ClassLoader[])new ClassLoader[0]));
        }
        return new Reflections((org.reflections.Configuration)new ConfigurationBuilder().setUrls(urls).addScanners(new Scanner[]{Scanners.TypesAnnotated, Scanners.SubTypes}));
    }

    @Bean
    public ProxyBeanDefinitionRegister proxyBeanDefinitionRegister(Reflections reflections) {
        logger.info("[PHOENIX-UNICOM] load unicom proxy register.");
        return new ProxyBeanDefinitionRegister(reflections, this.properties);
    }

    @Bean
    public UnicomInterfaceProxy unicomInterfaceProxy(Reflections reflections) {
        logger.info("[PHOENIX-UNICOM] load unicom interface proxy.");
        return new UnicomInterfaceProxy(reflections, this.properties);
    }

    @Bean
    public UnicomInterfaceProxyFactoryBean unicomInterfaceProxyFactoryBean() {
        return new UnicomInterfaceProxyFactoryBean();
    }

    @Bean
    public UnicomAdapterProxy unicomAdapterProxy(Reflections reflections) {
        logger.info("[PHOENIX-UNICOM] load unicom adapter proxy.");
        return new UnicomAdapterProxy(reflections, this.properties);
    }

    @Bean
    public UnicomAdapterProxyFactoryBean unicomAdapterProxyFactoryBean() {
        return new UnicomAdapterProxyFactoryBean();
    }

    @Bean
    public DefaultUnicomAdapter defaultUnicomAdapter() {
        return new DefaultUnicomAdapter();
    }

    public void setEnvironment(Environment environment) {
        this.properties = UnicomProperties.from(environment);
    }
}

