/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.config;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.cbpl.unicom.config.InvokeModeConfig;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="cbpl.unicom")
public class UnicomProperties {
    public static final String UNICOM_PREFIX = "cbpl.unicom";
    private boolean enabled;
    private List<String> basePackage = CollUtil.toList((Object[])new String[]{"com.elitesland", "com.elitescloud"});
    private List<InvokeModeConfig> businessDomain;
    private String defaultAdapter;

    public InvokeModeConfig invokeMode(String domainName) {
        if (CollUtil.isEmpty(this.businessDomain)) {
            return null;
        }
        List collect = this.businessDomain.stream().filter(row -> row.getName().equals(domainName)).collect(Collectors.toList());
        if (CollUtil.isEmpty(collect)) {
            return null;
        }
        if (collect.size() > 1) {
            throw new IllegalArgumentException("[UNICOM-CONFIG] cbpl.unicom.business-domain, name[" + domainName + "] multiple configurations.");
        }
        return (InvokeModeConfig)collect.get(0);
    }

    public static UnicomProperties from(Environment environment) {
        Binder env = Binder.get((Environment)environment);
        BindResult properties = env.bind(UNICOM_PREFIX, UnicomProperties.class);
        return properties.isBound() ? (UnicomProperties)properties.get() : new UnicomProperties();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getBasePackage() {
        return this.basePackage;
    }

    public List<InvokeModeConfig> getBusinessDomain() {
        return this.businessDomain;
    }

    public String getDefaultAdapter() {
        return this.defaultAdapter;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBasePackage(List<String> basePackage) {
        this.basePackage = basePackage;
    }

    public void setBusinessDomain(List<InvokeModeConfig> businessDomain) {
        this.businessDomain = businessDomain;
    }

    public void setDefaultAdapter(String defaultAdapter) {
        this.defaultAdapter = defaultAdapter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnicomProperties)) {
            return false;
        }
        UnicomProperties other = (UnicomProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        List<String> this$basePackage = this.getBasePackage();
        List<String> other$basePackage = other.getBasePackage();
        if (this$basePackage == null ? other$basePackage != null : !((Object)this$basePackage).equals(other$basePackage)) {
            return false;
        }
        List<InvokeModeConfig> this$businessDomain = this.getBusinessDomain();
        List<InvokeModeConfig> other$businessDomain = other.getBusinessDomain();
        if (this$businessDomain == null ? other$businessDomain != null : !((Object)this$businessDomain).equals(other$businessDomain)) {
            return false;
        }
        String this$defaultAdapter = this.getDefaultAdapter();
        String other$defaultAdapter = other.getDefaultAdapter();
        return !(this$defaultAdapter == null ? other$defaultAdapter != null : !this$defaultAdapter.equals(other$defaultAdapter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnicomProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        List<String> $basePackage = this.getBasePackage();
        result = result * 59 + ($basePackage == null ? 43 : ((Object)$basePackage).hashCode());
        List<InvokeModeConfig> $businessDomain = this.getBusinessDomain();
        result = result * 59 + ($businessDomain == null ? 43 : ((Object)$businessDomain).hashCode());
        String $defaultAdapter = this.getDefaultAdapter();
        result = result * 59 + ($defaultAdapter == null ? 43 : $defaultAdapter.hashCode());
        return result;
    }

    public String toString() {
        return "UnicomProperties(enabled=" + this.isEnabled() + ", basePackage=" + this.getBasePackage() + ", businessDomain=" + this.getBusinessDomain() + ", defaultAdapter=" + this.getDefaultAdapter() + ")";
    }
}

