/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.proxy;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.unicom.adapter.DefaultUnicomAdapter;
import com.elitesland.cbpl.unicom.config.UnicomProperties;
import com.elitesland.cbpl.unicom.util.ApplicationContextGetBeanHelper;
import java.lang.reflect.Method;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class UnicomAdapterProxy
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(UnicomAdapterProxy.class);
    private final Reflections reflections;
    private final UnicomProperties properties;

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        Object provider = ApplicationContextGetBeanHelper.getBean(method.getName());
        if (provider instanceof DefaultUnicomAdapter && StrUtil.isNotEmpty((CharSequence)this.properties.getDefaultAdapter())) {
            String defaultAdapter = this.properties.getDefaultAdapter();
            provider = ApplicationContextGetBeanHelper.getBean(defaultAdapter);
        }
        return methodProxy.invoke(provider, args);
    }

    public UnicomAdapterProxy(Reflections reflections, UnicomProperties properties) {
        this.reflections = reflections;
        this.properties = properties;
    }
}

