/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.adapter;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.cbpl.unicom.adapter.UnicomAdapter;
import com.elitesland.cbpl.unicom.adapter.util.AdapterUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnicomAdapter
implements UnicomAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUnicomAdapter.class);

    @Override
    public Object filter(List<Object> providers) {
        for (Object row : providers) {
            logger.debug("[PHOENIX-UNICOM] load impl className({})", (Object)row.getClass().getSimpleName());
        }
        Optional<Object> customerProvider = AdapterUtil.matchCustomize(providers);
        if (customerProvider.isPresent()) {
            logger.debug("[PHOENIX-UNICOM] context provider: {}", (Object)customerProvider.getClass().getSimpleName());
            return customerProvider.get();
        }
        if (CollUtil.size(providers) == 1) {
            Object provider = providers.get(0);
            logger.debug("[PHOENIX-UNICOM] execute impl className({})", (Object)providers.get(0).getClass().getSimpleName());
            return provider;
        }
        String simpleNames = providers.stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(","));
        throw new RuntimeException("[PHOENIX-UNICOM] more than one `match tag` bean found among candidates: [" + simpleNames + "]");
    }
}

