package com.elitesland.cbpl.unicom.adapter;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.cbpl.unicom.adapter.util.AdapterUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2023/04/25
 */
@Slf4j
public class DefaultUnicomAdapter implements UnicomAdapter {

    @Override
    public Object filter(List<Object> providers) {
        for (Object row : providers) {
            logger.debug("[PHOENIX-UNICOM] load impl className({})", row.getClass().getSimpleName());
        }
        // 1.优先执行定开版本代码
        Optional<Object> customerProvider = AdapterUtil.matchCustomize(providers);
        if (customerProvider.isPresent()) {
            logger.debug("[PHOENIX-UNICOM] context provider: {}", customerProvider.getClass().getSimpleName());
            return customerProvider.get();
        }
        // 2.其次，执行唯一实现类
        if (CollUtil.size(providers) == 1) {
            Object provider = providers.get(0);
            logger.debug("[PHOENIX-UNICOM] execute impl className({})", providers.get(0).getClass().getSimpleName());
            return provider;
        }
        // 3.多个实现类报错
        String simpleNames = providers.stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(","));
        throw new RuntimeException("[PHOENIX-UNICOM] more than one `match tag` bean found among candidates: [" + simpleNames + "]");
    }
}
