package com.elitesland.cbpl.unicom.adapter.domain;

import org.springframework.util.Assert;

/**
 * Unicom上下文信息
 *
 * @author eric.hao
 * @since 2024/01/09
 */
public class UnicomSession {

    private static final ThreadLocal<String> UNICOM_TAG = new ThreadLocal<>();

    private UnicomSession() {
    }

    /**
     * 获取当前的 UnicomTag
     *
     * @return UnicomTag
     */
    public static String getCurrentUnicomTag() {
        return UNICOM_TAG.get();
    }

    /**
     * 设置当前UnicomTag
     *
     * @param unicomTag 实现类标识
     */
    public static void setCurrentUnicomTag(String unicomTag) {
        Assert.notNull(unicomTag, "UnicomTag标识必填");
        UNICOM_TAG.set(unicomTag);
    }

    /**
     * 清除当前UnicomTag
     */
    public static void clearCurrentUnicomTag() {
        UNICOM_TAG.remove();
    }
}
