package com.elitesland.cbpl.unicom.adapter.util;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;

import java.util.List;
import java.util.Optional;

import static com.elitesland.cbpl.unicom.domain.InvokeTag.TAG_CUSTOMIZED;

/**
 * @author eric.hao
 * @since 2024/01/09
 */
public class AdapterUtil {

    /**
     * 适配项目定开版本
     */
    public static boolean matchCustomize(Object provider) {
        UnicomTag annotation = provider.getClass().getAnnotation(UnicomTag.class);
        return TAG_CUSTOMIZED.equals(annotation.value());
    }

    /**
     * 适配项目定开实现类
     *
     * @param providers 实现类集合
     * @return 具体业务逻辑的实现类
     */
    public static Optional<Object> matchCustomize(List<Object> providers) {
        return providers.stream().filter(AdapterUtil::matchCustomize).findAny();
    }
}
