package com.elitesland.cbpl.unicom.proxy;

import lombok.Data;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.proxy.Enhancer;

/**
 * @author eric.hao
 * @since 2023/04/25
 */
@Data
public class UnicomAdapterProxyFactoryBean implements FactoryBean {

    private Class<?> unicomAdapter;

    @Autowired
    private UnicomAdapterProxy unicomAdapterProxy;

    @Override
    public Object getObject() {
        Enhancer enhancer = new Enhancer();
        // 设置委托基类
        enhancer.setSuperclass(unicomAdapter);
        // 设置拦截器：所有方法转发到同一拦截器
        enhancer.setCallback(unicomAdapterProxy);
        // 通过无参构造方法创建代理子类实例
        return enhancer.create();
    }

    @Override
    public Class<?> getObjectType() {
        return unicomAdapter;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}