package com.elitesland.cbpl.unicom.proxy;

import lombok.Data;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.proxy.Enhancer;

/**
 * @author eric.hao
 * @since 2022/06/28
 */
@Data
public class UnicomInterfaceProxyFactoryBean implements FactoryBean {

    private Class<?> unicomInterface;

    @Autowired
    private UnicomInterfaceProxy unicomInterfaceProxy;

    @Override
    public Object getObject() {
        Enhancer enhancer = new Enhancer();
        // 设置委托基类
        enhancer.setSuperclass(unicomInterface);
        // 设置拦截器：所有方法转发到同一拦截器
        enhancer.setCallback(unicomInterfaceProxy);
        // 通过无参构造方法创建代理子类实例
        return enhancer.create();
    }

    @Override
    public Class<?> getObjectType() {
        return unicomInterface;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}