package com.elitesland.cbpl.unicom.util;

import com.elitesland.cbpl.unicom.adapter.domain.UnicomSession;

import java.util.function.Supplier;

/**
 * @author eric.hao
 * @since 2024/01/09
 */
public class UnicomClient {

    /**
     * 执行指定的实现类
     *
     * @param executor  业务操作
     * @param unicomTag 策略标识
     * @param <T>       数据类型
     * @return 执行结果
     */
    public static <T> T supply(Supplier<T> executor, String unicomTag) {
        UnicomSession.setCurrentUnicomTag(unicomTag);
        T result = executor.get();
        UnicomSession.clearCurrentUnicomTag();
        return result;
    }

    /**
     * 执行指定的实现类
     *
     * @param executor  业务操作
     * @param unicomTag 策略标识
     */
    public static void run(Runnable executor, String unicomTag) {
        UnicomSession.setCurrentUnicomTag(unicomTag);
        executor.run();
        UnicomSession.clearCurrentUnicomTag();
    }
}
