/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.adapter;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.unicom.adapter.UnicomAdapter;
import com.elitesland.cbpl.unicom.adapter.domain.UnicomSession;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecifyAdapter
implements UnicomAdapter {
    private static final Logger logger = LoggerFactory.getLogger(SpecifyAdapter.class);
    private static final String ERR_TENANT_CONTEXT_CONFIG = "\u627e\u4e0d\u5230\u5b9e\u65bd\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";

    @Override
    public Object filter(List<Object> providers) {
        for (Object row : providers) {
            logger.debug("[PHOENIX-UNICOM] load impl className({})", (Object)row.getClass().getSimpleName());
        }
        logger.debug("[PHOENIX-UNICOM] unicom session tag: {}", (Object)UnicomSession.getCurrentUnicomTag());
        Object customerProvider = providers.stream().filter(this::matchTarget).findAny().orElseThrow(() -> new RuntimeException(ERR_TENANT_CONTEXT_CONFIG));
        logger.debug("[PHOENIX-UNICOM] context provider: {}", (Object)customerProvider.getClass().getSimpleName());
        return customerProvider;
    }

    private boolean matchTarget(Object provider) {
        String unicomTag = UnicomSession.getCurrentUnicomTag();
        if (StrUtil.isBlank((CharSequence)unicomTag)) {
            return false;
        }
        UnicomTag annotation = provider.getClass().getAnnotation(UnicomTag.class);
        return unicomTag.equals(annotation.value());
    }
}

