package com.elitesland.cbpl.unicom.annotation;

import java.lang.annotation.*;

/**
 * @author eric.hao
 * @since 2022/07/12
 */
@Target({ElementType.TYPE})
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface UnicomTag {

    /**
     * 标签，区分不同实现类<br/>
     * 实施策略取决于{@link com.elitesland.cbpl.unicom.adapter.UnicomAdapter}
     */
    String value();

    /**
     * Dubbo Version<br/>
     * 仅在调用方式为DUBBO时生效<br/>
     * 等价于 @DubboService(version = "1.0.0") 的版本号
     */
    String dv() default "";
}
