package com.elitesland.cbpl.unicom.adapter;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.unicom.adapter.domain.UnicomSession;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/01/09
 */
@Slf4j
public class SpecifyAdapter implements UnicomAdapter {

    private static final String ERR_TENANT_CONTEXT_CONFIG = "找不到实施方案，请联系管理员";

    @Override
    public Object filter(List<Object> providers) {
        for (Object row : providers) {
            logger.debug("[PHOENIX-UNICOM] load impl className({})", row.getClass().getSimpleName());
        }
        logger.debug("[PHOENIX-UNICOM] unicom session tag: {}", UnicomSession.getCurrentUnicomTag());
        Object customerProvider = providers.stream().filter(this::matchTarget).findAny()
                .orElseThrow(() -> new RuntimeException(ERR_TENANT_CONTEXT_CONFIG));
        logger.debug("[PHOENIX-UNICOM] context provider: {}", customerProvider.getClass().getSimpleName());
        return customerProvider;
    }

    /**
     * 从UnicomSession中，读取标签值
     * 指定执行该策略，没找到则报错
     */
    private boolean matchTarget(Object provider) {
        String unicomTag = UnicomSession.getCurrentUnicomTag();
        if (StrUtil.isBlank(unicomTag)) {
            return false;
        }
        UnicomTag annotation = provider.getClass().getAnnotation(UnicomTag.class);
        return unicomTag.equals(annotation.value());
    }
}
