/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unionpay.shoupay.data.controller;

import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayDeviceService;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayDeviceQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayDeviceSaveParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayDeviceDetailVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayDeviceRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayTerminalRespVO;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6536\u94b1\u5427 - \u6536\u94f6\u7ec8\u7aef\u8bbe\u5907"})
@ApiSupport(author="eric.hao", order=2)
@RestController
@RequestMapping(value={"/unionpay/shoupay/device"})
public class ShouPayDeviceController {
    private static final Logger logger = LoggerFactory.getLogger(ShouPayDeviceController.class);
    private final ShouPayDeviceService shouPayDeviceService;

    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public List<ShouPayDeviceRespVO> query(@RequestBody ShouPayDeviceQueryParamVO query) {
        logger.info("[PHOENIX-UNIONPAY] query list param = {}", (Object)query);
        return this.shouPayDeviceService.shouPayDeviceByParam(query);
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{deviceId}"})
    public ShouPayDeviceDetailVO detail(@PathVariable(value="deviceId") String deviceId) {
        logger.info("[PHOENIX-UNIONPAY] query detail by deviceId = {}", (Object)deviceId);
        return this.shouPayDeviceService.shouPayDeviceById(deviceId);
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"/save"})
    public Long save(@RequestBody ShouPayDeviceSaveParamVO saveParam) {
        logger.info("[PHOENIX-UNIONPAY] create/update record, saveParam = {}", (Object)saveParam);
        return this.shouPayDeviceService.save(saveParam);
    }

    @ApiOperation(value="\u8bbe\u5907\u6fc0\u6d3b")
    @PutMapping(value={"/{deviceId}/activate"})
    public ShouPayTerminalRespVO activate(@PathVariable(value="deviceId") String deviceId) {
        logger.info("[PHOENIX-UNIONPAY] activate deviceId = {}", (Object)deviceId);
        return this.shouPayDeviceService.activate(deviceId);
    }

    @ApiOperation(value="\u624b\u52a8\u7b7e\u5230")
    @PutMapping(value={"/{deviceId}/checkin"})
    public ShouPayTerminalRespVO checkin(@PathVariable(value="deviceId") String deviceId) {
        logger.info("[PHOENIX-UNIONPAY] checkin deviceId = {}", (Object)deviceId);
        return this.shouPayDeviceService.checkin(deviceId);
    }

    public ShouPayDeviceController(ShouPayDeviceService shouPayDeviceService) {
        this.shouPayDeviceService = shouPayDeviceService;
    }
}

