package com.elitesland.cbpl.unionpay.shoupay.cache;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayDeviceService;
import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayVendorService;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayVendorQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayDeviceDetailVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayVendorRespVO;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
@Slf4j
@Data
@Component
@RequiredArgsConstructor
public class ShouPayCache {

    /**
     * 终端设备列表
     */
    private Map<String, ShouPayDeviceVO> devices;

    /**
     * 系统加载时 初始化可用设备列表
     * 写入分布式缓存，比如redis；并进行每日签到逻辑；
     */
    @PostConstruct
    public void init() {
        // TODO
        logger.info("[PHOENIX-UNIONPAY] load devices.");
    }

    /**
     * 根据设备，读取相关配置参数
     *
     * @param deviceId 设备号
     * @return 相关各配置项
     */
    public ShouPayDeviceVO get(String deviceId) {
        ShouPayDeviceVO device = queryByDeviceId(deviceId);
        if (ObjectUtil.isNull(device)) {
            throw new IllegalArgumentException("[PHOENIX-UNIONPAY] deviceId(" + deviceId + ") not found.");
        }
        return device;
    }

    private final ShouPayVendorService vendorService;
    private final ShouPayDeviceService deviceService;

    /**
     * 实时查询数据库方案
     * TODO 临时方案，会废弃
     *
     * @param deviceId 设备号
     * @return 相关各配置项
     */
    @Deprecated
    private ShouPayDeviceVO queryByDeviceId(String deviceId) {
        // 查询环境配置
        ShouPayVendorQueryParamVO vendorQuery = new ShouPayVendorQueryParamVO();
        vendorQuery.setDefaultFlag(1);
        vendorQuery.setDeleteFlag(0);
        List<ShouPayVendorRespVO> vendors = vendorService.shouPayVendorByParam(vendorQuery);
        if (CollUtil.isEmpty(vendors)) {
            throw new IllegalArgumentException("[PHOENIX-UNIONPAY] vendors default environment not found.");
        }
        if (vendors.size() > 1) {
            throw new IllegalArgumentException("[PHOENIX-UNIONPAY] vendors have multiple default environment.");
        }

        // 查询指定设备
        ShouPayDeviceDetailVO device = deviceService.shouPayDeviceById(deviceId);

        ShouPayDeviceVO deviceVO = new ShouPayDeviceVO();
        // 环境
        deviceVO.setVendorSn(vendors.get(0).getVendorSn());
        deviceVO.setVendorKey(vendors.get(0).getVendorKey());
        deviceVO.setAppId(vendors.get(0).getAppId());
        deviceVO.setEnvironment(vendors.get(0).getEnvironment());
        deviceVO.setApiDomain(vendors.get(0).getApiDomain());
        deviceVO.setSdkVersion(vendors.get(0).getSdkVersion());
        // 设备
        deviceVO.setDeviceId(device.getDeviceId());
        deviceVO.setDeviceName(device.getDeviceName());
        deviceVO.setClientSn(device.getClientSn());
        deviceVO.setActivateCode(device.getActivateCode());
        deviceVO.setTerminalSn(device.getTerminalSn());
        deviceVO.setTerminalKey(device.getTerminalKey());
        deviceVO.setLastUpdateTime(device.getLastUpdateTime());
        return deviceVO;
    }
}
