package com.elitesland.cbpl.unionpay.shoupay.cache;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
@Data
public class ShouPayDeviceVO {

    // ======== 账号、环境 配置项 ======== //

    @ApiModelProperty(value = "开发者序号")
    private String vendorSn;

    @ApiModelProperty(value = "开发者密钥")
    private String vendorKey;

    @ApiModelProperty(value = "应用编号")
    private String appId;

    @ApiModelProperty(value = "指定环境")
    private String environment;

    @ApiModelProperty(value = "接口域名")
    private String apiDomain;

    @ApiModelProperty(value = "SDK版本")
    private String sdkVersion;

    // ======== 终端设备 配置项 ======== //

    @ApiModelProperty(value = "收银终端序列号")
    private String deviceId;

    @ApiModelProperty(value = "收银终端名称")
    private String deviceName;

    @ApiModelProperty(value = "收银终端编号")
    private String clientSn;

    @ApiModelProperty(value = "激活码")
    private String activateCode;

    @ApiModelProperty(value = "终端号")
    private String terminalSn;

    @ApiModelProperty(value = "终端密钥")
    private String terminalKey;

    @ApiModelProperty(value = "终端密钥的上次更新时间")
    private LocalDateTime lastUpdateTime;

    // 上次更新时间为空 || 更新时间相差1天
    public boolean needCheckin() {
        if (ObjectUtil.isNotNull(lastUpdateTime)) {
            Date yesterday = new DateTime(this.lastUpdateTime);
            Date today = new Date();
            return DateUtil.betweenDay(yesterday, today, true) > 0;
        }
        return false;
    }
}
