package com.elitesland.cbpl.unionpay.shoupay.common.constant;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
public abstract class ShouPayConstant {

    /**
     * 终端激活
     * <li>激活终端是为了拿到交易接口签名需要的参数（终端号和终端密钥），激活完一台终端，开发者需要把终端号和终端密钥信息持久化保持，以后每日签到更新终端密钥。</li>
     * <li>不管是支付（B扫C）还是预下单（C扫B）以及wap支付都需要激活后才能调用。</li>
     * <li>一个终端只需激活一次，之后调用支付类接口（不论支付还是预下单）都不需要再激活。</li>
     * <li>不需要每次进入程序时都调用激活函数。</li>
     * <li>收钱吧不对同一个终端的激活次数做限制，开发者需要自行判断终端是否已激活。</li>
     * <li>服务商参数vendor_sn和vendor_key是不变的，建议写死在程序里，以后直接输入激活码激活终端。</li>
     */
    public static final String TERMINAL_ACTIVATE = "/terminal/activate";

    /**
     * 终端签到
     * <li>签到的作用是更新终端密钥，获取每日最新密钥。开发者需要把最新的terminal_key保存下来。</li>
     * <li>Web API 建议每自然天执行第一笔核心支付接口调用时，自动执行签到操作。</li>
     * <li>如果签到失败，一般都是更换设备导致。解决方法：重新申请新的激活码。</li>
     */
    public static final String TERMINAL_CHECK_IN = "/terminal/checkin";

    /**
     * 付款
     * <li>使用pay接口支付(b扫c)40s左右没输入密码支付会提示超时,需要重新调用支付接口去重新支付。</li>
     * <li>建议对接方加入一个手动查询的按钮去处理可能出现的单边账，</li>
     * <li>如果手动查询得到的状态依旧不是成功，就需要联系收钱吧客服人工接入了。</li>
     */
    public static final String UPAY_V2_PAY = "/upay/v2/pay";

    /**
     * 退款
     * <li>三个月以内的订单都可以进行退款。</li>
     * <li>退款接口，不限制退款次数，可操作至剩余金额为0。</li>
     * <li>退款成功后，手续费按照退款金额占订单金额比例系数乘以订单总手续费进行手续费退还。</li>
     * <li>一笔退款不能重复使用退款序列号，不然退款会失败。</li>
     */
    public static final String UPAY_V2_REFUND = "/upay/v2/refund";

    /**
     * 查询
     * <li>1) 调用预下单接口(precreate)预下单成功后，需要调用查询接口发起轮询。</li>
     * <li>2) 调用支付接口(pay)支付后没有得到订单的最终状态，需要调用查询接口获取订单最终状态。</li>
     * <li>3) 调用退款接口(refund)发起退款后没有得到退款最终状态，需要调用查询接口获取退款最终状态。</li>
     * <li>4) 调用撤单接口(revoke/cancel)发起撤单或冲正之后没有得到撤单的最终状态，需要调用查询接口获取撤单的最终状态。</li>
     * <li>5) 为了预防出现单边账，建议对接方手动加一个查询按钮，当支付完成后，如果消费者支付成功，但是终端显示支付失败或者状态不明确，这个时候可以给收银员一个手动查询订单状态的操作，如果查询得到的状态依旧不是成功，就需要联系收钱吧客服人工接入了。</li>
     */
    public static final String UPAY_V2_QUERY = "/upay/v2/query";

    /**
     * 自动撤单
     * <li>自动撤单接口是为了避免出现单边账而出现的。</li>
     * <li>当一笔交易状态未知时，为了避免产生单边账，就需要调用自动撤单接口发起撤单，从而避免产生单边账</li>
     */
    public static final String UPAY_V2_CANCEL = "/upay/v2/cancel";

    /**
     * 手动撤单
     * <li>如果一笔订单已经支付成功，在系统规定的时间范围内，可以调用这个接口完成全额退款，并且不会触发任何手续费。</li>
     * <li>手动撤单和自动撤单的区别只是撤单目的不同，实际执行的业务逻辑是完全一样的。</li>
     */
    public static final String UPAY_V2_REVOKE = "/upay/v2/revoke";

    /**
     * 预下单
     * <li>为了保证第三方系统可稳定、高效收到订单处理结果，我们建议开发者使用主动轮询加回调的方式处理。
     * 回调的通知间隔是1s, 5s, 30s, 600s。</li>
     * <li>收钱吧目前所有预下单的订单有效支付时长约为4分钟，在订单有效期内，开发者可按以下建议发起轮询：</li>
     * <ul>
     *     <li>第0-1分钟，轮询间隔为10s, 5s, 5s, 10s, 10s, 10s, 10s；</li>
     *     <li>第1-2分钟，轮询间隔为20s;</li>
     *     <li>第2-3分钟，轮询间隔为30s;</li>
     *     <li>第3-4分钟，轮询间隔为30s;</li>
     *     <li>第6分钟，做最后一次轮询。</li>
     * </ul>
     * <li>如果第三方系统已通过轮询或者回调获得了支付结果，可停止轮询。</li>
     */
    public static final String UPAY_V2_PRE_CREATE = "/upay/v2/precreate";
}
