package com.elitesland.cbpl.unionpay.shoupay.common.util;

import org.apache.commons.codec.digest.DigestUtils;

import java.io.UnsupportedEncodingException;
import java.util.Random;

/**
 * 收钱吧提供的MD5工具类
 *
 * @author yaming.rong
 * @since 2023/11/27
 */
public class MD5Util {

    public static String encryptMd5(String string) throws UnsupportedEncodingException {
        return encryptMd5(string, "UTF-8");
    }

    public static String encryptMd5(String string, String charSet) throws UnsupportedEncodingException {
        return DigestUtils.md5Hex(string.getBytes(charSet));
    }

    /**
     * 计算字符串的MD5值
     *
     * @param signStr:签名字符串
     * @return
     */
    public static String getSign(String signStr) {
        try {
            return MD5Util.encryptMd5(signStr);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getClient_Sn(int codeLength) {
        while (true) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < codeLength; i++) {
                if (i == 0)
                    // first field will not start with 0.
                    sb.append(new Random().nextInt(9) + 1);
                else
                    sb.append(new Random().nextInt(10));
            }
            return sb.toString();
        }
    }
}
