package com.elitesland.cbpl.unionpay.shoupay.config;

import com.elitesland.cbpl.unionpay.shoupay.cache.ShouPayCache;
import com.elitesland.cbpl.unionpay.shoupay.data.controller.ShouPayDemo;
import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayDeviceService;
import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayVendorService;
import com.elitesland.cbpl.unionpay.shoupay.proxy.ShouPayProxy;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.unionpay.shoupay.config.ShouPayProperties.SHOU_PAY_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(ShouPayProperties.class)
@ConditionalOnProperty(prefix = SHOU_PAY_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class ShouPayConfig {

    /**
     * 收钱吧 - 缓存配置
     */
    @Bean
    public ShouPayCache shouPayCache(ShouPayVendorService vendorService, ShouPayDeviceService deviceService) {
        return new ShouPayCache(vendorService, deviceService);
    }

    /**
     * 收钱吧 - 代理工具类
     */
    @Bean
    public ShouPayProxy shouPayProxy(ShouPayCache shouPayCache) {
        logger.info("[PHOENIX-UNIONPAY] load shouqianba pay (ShouPay).");
        return new ShouPayProxy(shouPayCache);
    }

    /**
     * demo测试接口
     */
    @Bean
    public ShouPayDemo shouPayDemo(ShouPayProxy shouPayProxy, ShouPayDeviceService deviceService) {
        return new ShouPayDemo(shouPayProxy, deviceService);
    }
}
