package com.elitesland.cbpl.unionpay.shoupay.config;

import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.unionpay.shoupay.config.ShouPayProperties.SHOU_PAY_CONFIG_PREFIX;

/**
 * 收钱吧 相关配置
 *
 * @author eric.hao
 * @since 2023/11/27
 */
@Data
@ConfigurationProperties(prefix = SHOU_PAY_CONFIG_PREFIX)
public class ShouPayProperties implements InitializingBean {

    public static final String SHOU_PAY_CONFIG_PREFIX = "cbpl.unionpay.shoupay";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    public static boolean SHOU_PAY_ENABLED;

    @Override
    public void afterPropertiesSet() throws Exception {
        SHOU_PAY_ENABLED = enabled;
    }
}
