package com.elitesland.cbpl.unionpay.shoupay.data.config;

import com.elitesland.cbpl.tool.swagger.Swagger2Config;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.spring.web.plugins.Docket;

/**
 * @author eric.hao
 * @since 2023/12/15
 */
@Configuration
@ConditionalOnProperty(prefix = "knife4j", name = "enable", havingValue = "true")
@RequiredArgsConstructor
public class ShouPaySwaggerConfig {

    private final Swagger2Config swagger2Config;

    @Bean
    public Docket shouPayRestApi() {
        return swagger2Config.createSwaggerBean("收钱吧API", "com.elitesland.cbpl.unionpay.shoupay");
    }
}
