package com.elitesland.cbpl.unionpay.shoupay.data.controller;

import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayDeviceService;
import com.elitesland.cbpl.unionpay.shoupay.domain.base.ShouPayRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayCancelParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayRefundParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayTradeParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.*;
import com.elitesland.cbpl.unionpay.shoupay.proxy.ShouPayProxy;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
@Slf4j
@Api(tags = "收钱吧 - 常用API示例")
@ApiSupport(author = "eric.hao", order = 3)
@RequestMapping("/demo/unionpay/shoupay")
@RequiredArgsConstructor
public class ShouPayDemo {

    private final ShouPayProxy shouPayProxy;
    private final ShouPayDeviceService shouPayDeviceService;

    @ApiOperation("01.设备激活")
    @GetMapping("/activate")
    public ShouPayTerminalRespVO activate(String deviceId) {
        return shouPayDeviceService.activate(deviceId);
    }

    @ApiOperation("02.设备签到")
    @GetMapping("/checkin")
    public ShouPayTerminalRespVO checkin(String deviceId) {
        return shouPayDeviceService.checkin(deviceId);
    }

    @ApiOperation("03.付款")
    @PostMapping("/pay")
    public ShouPayRespVO<ShouPayTradeRespVO> pay(String deviceId, @RequestBody @Validated ShouPayTradeParamVO paramVO) {
        return shouPayProxy.pay(deviceId, paramVO);
    }

    @ApiOperation("04.退款")
    @PostMapping("/refund")
    public ShouPayRespVO<ShouPayRefundRespVO> refund(String deviceId, @RequestBody @Validated ShouPayRefundParamVO paramVO) {
        return shouPayProxy.refund(deviceId, paramVO);
    }

    @ApiOperation("05.查询")
    @PostMapping("/query")
    public ShouPayRespVO<ShouPayQueryRespVO> query(String deviceId, @RequestBody @Validated ShouPayQueryParamVO paramVO) {
        return shouPayProxy.query(deviceId, paramVO);
    }

    @ApiOperation("06.自动撤单")
    @PostMapping("/cancel")
    public ShouPayRespVO<ShouPayCancelRespVO> cancel(String deviceId, @RequestBody @Validated ShouPayCancelParamVO paramVO) {
        return shouPayProxy.cancel(deviceId, paramVO);
    }

    @ApiOperation("06.手动撤单")
    @PostMapping("/revoke")
    public ShouPayRespVO<ShouPayCancelRespVO> revoke(String deviceId, @RequestBody @Validated ShouPayCancelParamVO paramVO) {
        return shouPayProxy.revoke(deviceId, paramVO);
    }
}
