package com.elitesland.cbpl.unionpay.shoupay.data.controller;

import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayVendorService;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayVendorQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayVendorSaveParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayVendorDetailVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayVendorRespVO;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
@Slf4j
@Api(tags = "收钱吧 - 环境参数")
@ApiSupport(author = "eric.hao", order = 1)
@RestController
@RequestMapping("/unionpay/shoupay/vendor")
@AllArgsConstructor
public class ShouPayVendorController {

    private final ShouPayVendorService shouPayVendorService;

    @ApiOperation(value = "不分页查询")
    @PostMapping(value = "/query")
    public List<ShouPayVendorRespVO> query(@RequestBody ShouPayVendorQueryParamVO query) {
        logger.info("[ShouPayVendor] query list param = {}", query);
        return shouPayVendorService.shouPayVendorByParam(query);
    }

    @ApiOperation(value = "明细查询")
    @GetMapping(value = "/detail/{id}")
    public ShouPayVendorDetailVO detail(@PathVariable("id") Long id) {
        logger.info("[ShouPayVendor] query detail by id = {}", id);
        return shouPayVendorService.shouPayVendorById(id);
    }

    @ApiOperation(value = "新增或修改")
    @PostMapping(value = "/save")
    public Long save(@RequestBody ShouPayVendorSaveParamVO saveParam) {
        logger.info("[ShouPayVendor] create/update record, saveParam = {}", saveParam);
        return shouPayVendorService.save(saveParam);
    }
}
