package com.elitesland.cbpl.unionpay.shoupay.data.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.*;
import lombok.experimental.Accessors;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "shoupay_device")
@org.hibernate.annotations.Table(appliesTo = "shoupay_device", comment = "收钱吧-收银终端设备")
@ApiModel("收钱吧-收银终端设备")
public class ShouPayDeviceDO implements Serializable {

	private static final long serialVersionUID = 3816126569320113675L;

	/**
	 * MySQL 数据库
	 */
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column
	@Comment("唯一主键")
	private Long id;

	/**
	 * 收银终端序列号
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "收银终端序列号")
	@Column(name = "device_id", nullable = true, length = 128)
	private String deviceId;

	/**
	 * 收银终端名称
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "收银终端名称")
	@Column(name = "device_name", nullable = true, length = 128)
	private String deviceName;

	/**
	 * 收银终端编号
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "收银终端编号")
	@Column(name = "client_sn", nullable = true, length = 128)
	private String clientSn;

	/**
	 * 激活码
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "激活码")
	@Column(name = "activate_code", nullable = true, length = 128)
	private String activateCode;

	/**
	 * 终端号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "终端号：通过每日签到更新并持久化")
	@Column(name = "terminal_sn", nullable = true, length = 128)
	private String terminalSn;

	/**
	 * 终端密钥
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "终端密钥：通过每日签到更新并持久化")
	@Column(name = "terminal_key", nullable = true, length = 128)
	private String terminalKey;

	/**
	 * 终端密钥的上次更新时间
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "终端密钥的上次更新时间")
	@Column(name = "last_update_time", nullable = true)
	private LocalDateTime lastUpdateTime;

	@ApiModelProperty(value = "删除标识")
	@Column(name = "delete_flag", nullable = true, length = 1)
	private Integer deleteFlag;

	@ApiModelProperty(value = "创建时间")
	@Column(name = "create_time")
	private LocalDateTime createTime;

	@ApiModelProperty(value = "修改时间")
	@Column(name = "modify_time")
	private LocalDateTime modifyTime;
}
