package com.elitesland.cbpl.unionpay.shoupay.data.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
@Entity
@Table(name = "shoupay_vendor")
@org.hibernate.annotations.Table(appliesTo = "shoupay_vendor", comment = "收钱吧-环境参数")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ShouPayVendorDO implements Serializable {

    private static final long serialVersionUID = 829376345124722647L;

    /**
     * MySQL 数据库
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column
    @Comment("唯一主键")
    private Long id;

    /**
     * 开发者序号
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "开发者序号")
    @Column(name = "vendor_sn", nullable = true, length = 64)
    private String vendorSn;

    /**
     * 开发者密钥
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "开发者密钥")
    @Column(name = "vendor_key", nullable = true, length = 64)
    private String vendorKey;

    /**
     * 应用编号
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "应用编号")
    @Column(name = "app_id", nullable = true, length = 64)
    private String appId;

    /**
     * 指定环境
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "指定环境")
    @Column(name = "environment", nullable = true, length = 32)
    private String environment;

    /**
     * 接口域名
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "接口域名")
    @Column(name = "api_domain", nullable = true, length = 128)
    private String apiDomain;

    /**
     * SDK版本
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "SDK版本")
    @Column(name = "sdk_version", nullable = true, length = 32)
    private String sdkVersion;

    /**
     * <li>有且仅有一个环境为默认状态</li>
     * <li>调用接口时，会使用默认状态的相关开发参数</li>
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "是否默认")
    @Column(name = "default_flag", nullable = true, length = 1)
    private Integer defaultFlag;

    @ApiModelProperty(value = "删除标识")
    @Column(name = "delete_flag", nullable = true, length = 1)
    private Integer deleteFlag;

    @ApiModelProperty(value = "创建时间")
    @Column(name = "create_time")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改时间")
    @Column(name = "modify_time")
    private LocalDateTime modifyTime;
}
