package com.elitesland.cbpl.unionpay.shoupay.data.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayVendorQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayVendorRespVO;
import com.elitesland.cbpl.unionpay.shoupay.data.entity.QShouPayVendorDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
@Component
@RequiredArgsConstructor
public class ShouPayVendorRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QShouPayVendorDO shouPayVendorDO = QShouPayVendorDO.shouPayVendorDO;
    private final QBean<ShouPayVendorRespVO> shouPayVendorVO = Projections.bean(
            ShouPayVendorRespVO.class,
            shouPayVendorDO.id,
            shouPayVendorDO.vendorSn,
            shouPayVendorDO.vendorKey,
            shouPayVendorDO.appId,
            shouPayVendorDO.environment,
            shouPayVendorDO.apiDomain,
            shouPayVendorDO.sdkVersion,
            shouPayVendorDO.defaultFlag,
            shouPayVendorDO.deleteFlag,
            shouPayVendorDO.createTime,
            shouPayVendorDO.modifyTime
    );

    private Predicate where(ShouPayVendorQueryParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(shouPayVendorDO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(query.getId())) {
            predicates.add(shouPayVendorDO.id.eq(query.getId()));
        }
        if (StrUtil.isNotBlank(query.getVendorSn())) {
            predicates.add(shouPayVendorDO.vendorSn.eq(query.getVendorSn()));
        }
        if (StrUtil.isNotBlank(query.getVendorKey())) {
            predicates.add(shouPayVendorDO.vendorKey.eq(query.getVendorKey()));
        }
        if (StrUtil.isNotBlank(query.getAppId())) {
            predicates.add(shouPayVendorDO.appId.eq(query.getAppId()));
        }
        if (StrUtil.isNotBlank(query.getEnvironment())) {
            predicates.add(shouPayVendorDO.environment.eq(query.getEnvironment()));
        }
        if (StrUtil.isNotBlank(query.getApiDomain())) {
            predicates.add(shouPayVendorDO.apiDomain.eq(query.getApiDomain()));
        }
        if (StrUtil.isNotBlank(query.getSdkVersion())) {
            predicates.add(shouPayVendorDO.sdkVersion.eq(query.getSdkVersion()));
        }
        if (ObjectUtil.isNotNull(query.getDefaultFlag())) {
            predicates.add(shouPayVendorDO.defaultFlag.eq(query.getDefaultFlag()));
        }
        if (ObjectUtil.isNotNull(query.getDeleteFlag())) {
            predicates.add(shouPayVendorDO.deleteFlag.eq(query.getDeleteFlag()));
        }
        if (ObjectUtil.isNotNull(query.getCreateTime())) {
            predicates.add(shouPayVendorDO.createTime.eq(query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull(query.getModifyTime())) {
            predicates.add(shouPayVendorDO.modifyTime.eq(query.getModifyTime()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ShouPayVendorRespVO> shouPayVendorByParam(ShouPayVendorQueryParamVO query) {
        JPAQuery<ShouPayVendorRespVO> jpaQuery = jpaQueryFactory.select(shouPayVendorVO)
                .from(shouPayVendorDO);
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }
}
