package com.elitesland.cbpl.unionpay.shoupay.data.service.impl;

import com.elitesland.cbpl.unionpay.shoupay.data.convert.ShouPayVendorConvert;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayVendorQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.entity.ShouPayVendorDO;
import com.elitesland.cbpl.unionpay.shoupay.data.repo.ShouPayVendorRepo;
import com.elitesland.cbpl.unionpay.shoupay.data.repo.ShouPayVendorRepoProc;
import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayVendorService;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayVendorSaveParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayVendorDetailVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayVendorRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ShouPayVendorServiceImpl implements ShouPayVendorService {

    private final ShouPayVendorRepo shouPayVendorRepo;
    private final ShouPayVendorRepoProc shouPayVendorRepoProc;

    @Override
    public List<ShouPayVendorRespVO> shouPayVendorByParam(ShouPayVendorQueryParamVO query) {
        return shouPayVendorRepoProc.shouPayVendorByParam(query);
    }

    @Override
    public ShouPayVendorDetailVO shouPayVendorById(Long id) {
        Optional<ShouPayVendorDO> shouPayVendorDO = shouPayVendorRepo.findById(id);
        if (!shouPayVendorDO.isPresent()) {
            throw new RuntimeException("Not Found Data");
        }
        return ShouPayVendorConvert.INSTANCE.doToVO(shouPayVendorDO.get());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long save(ShouPayVendorSaveParamVO saveParam) {
        // 新增
        if (saveParam.isNew()) {
            ShouPayVendorDO shouPayVendorDO = ShouPayVendorConvert.INSTANCE.saveParamToDO(saveParam);
            shouPayVendorRepo.save(shouPayVendorDO);
            return shouPayVendorDO.getId();
        }
        // 修改
        else {
            Optional<ShouPayVendorDO> shouPayVendorDO = shouPayVendorRepo.findById(saveParam.getId());
            if (!shouPayVendorDO.isPresent()) {
                throw new RuntimeException("Not Found Data");
            }
            ShouPayVendorDO shouPayVendor = shouPayVendorDO.get();
            ShouPayVendorConvert.INSTANCE.saveParamMergeToDO(saveParam, shouPayVendor);
            shouPayVendorRepo.save(shouPayVendor);
            return shouPayVendor.getId();
        }
    }
}
