package com.elitesland.cbpl.unionpay.shoupay.domain.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * <strong>注意事项：</strong>
 * <li>sn与client_sn不能同时为空，优先按照sn查找订单</li>
 * <li>如果没有，再按照client_sn查询</li>
 *
 * @author eric.hao
 * @since 2023/11/28
 */
@Data
@ApiModel("自动撤单")
public class ShouPayCancelParamVO {

    @NotBlank(message = "收钱吧终端号不能为空")
    @Size(max = 32, message = "收钱吧终端号不能超过32位")
    @ApiModelProperty("收钱吧终端号")
    private String terminalSn;

    /**
     * 收钱吧系统内部唯一订单号 "7892259488292938"
     */
    @Size(max = 16, message = "收钱吧订单号不能超过16位")
    @ApiModelProperty("收钱吧唯一订单号")
    private String sn;

    /**
     * 必须在商户系统内唯一
     */
    @Size(max = 32, message = "平台订单号不能超过32位")
    @ApiModelProperty("商户系统订单号")
    private String clientSn;
}
