package com.elitesland.cbpl.unionpay.shoupay.domain.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <strong>返回示例（映射接收biz_response字段）：</strong>
 *
 * <p>1.撤单成功</p>
 * <pre><code class='json'>
 * {
 *     "result_code": "200",
 *     "biz_response": {
 *         "result_code": "CANCEL_SUCCESS",
 *         "data": {
 *             "sn": "7894259244064831",
 *             "client_sn": "22345677767776",
 *             "status": "SUCCESS",
 *             "payway": "3",
 *             "sub_payway": "1",
 *             "order_status": "CANCELED",
 *             "total_amount": "1",
 *             "net_amount": "0",
 *             "finish_time": "1450090828489",
 *             "subject": "wx",
 *             "store_id": "49"
 *         }
 *     }
 * }
 * </code></pre>
 *
 * <p>2.撤单失败</p>
 * <pre><code class='json'>
 * {
 *     "result_code": "200",
 *     "biz_response": {
 *         "result_code": "CANCEL_ERROR",
 *         "error_code": "UPAY_TCP_ORDER_NOT_REFUNDABLE",
 *         "error_message": "订单7894259244061958参与了活动并且无法撤销"
 *     }
 * }
 * </code></pre>
 *
 * @author eric.hao
 * @since 2023/11/28
 */
@Data
@ApiModel("撤单结果")
public class ShouPayCancelRespVO {

    @ApiModelProperty("状态码")
    private String resultCode;

    @ApiModelProperty("错误码")
    private String errorCode;

    @ApiModelProperty("错误原因")
    private String errorMessage;
}
