package com.elitesland.cbpl.unionpay.shoupay.domain.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2023/11/28
 */
@Data
@ApiModel("退款详情")
public class ShouPayRefundDetailRespVO {

    @ApiModelProperty("收钱吧终端号")
    private String terminalSn;

    @ApiModelProperty("收钱吧唯一订单号")
    private String sn;

    @ApiModelProperty("商户系统订单号")
    private String clientSn;

    @ApiModelProperty("退款流水状态")
    private String status;

    @ApiModelProperty("订单状态")
    private String orderStatus;

    @ApiModelProperty("支付方式")
    private String payway;

    @ApiModelProperty("支付方式名称")
    private String paywayName;

    /**
     * 支付宝或微信的订单号
     */
    @ApiModelProperty("支付平台的订单凭证号")
    private String tradeNo;

    /**
     * 原始交易实收金额
     */
    @ApiModelProperty("交易总金额")
    private String totalAmount;

    /**
     * 实收金额减退款金额
     */
    @ApiModelProperty("剩余金额")
    private String netAmount;

    @ApiModelProperty("本次操作退款金额")
    private String settlementAmount;

    /**
     * 时间戳，本次退款动作在收钱吧的完成时间。退款成功有值返回。	"1449646835244"
     */
    @ApiModelProperty("退款动作在收钱吧的完成时间")
    private String finishTime;

    /**
     * 时间戳，本次退款动作在微信或支付宝的完成时间。退款成功有值返回。	"1449646835221"
     */
    @ApiModelProperty("退款动作在支付平台完成的时间")
    private String channelFinishTime;

    /**
     * 交易时候的商品概述
     */
    @ApiModelProperty("商品概述")
    private String subject;

    /**
     * 执行本次退款的操作员
     */
    @ApiModelProperty("操作员")
    private String operator;
}
