package com.elitesland.cbpl.unionpay.shoupay.domain.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <strong>返回示例（映射接收biz_response字段）：</strong>
 *
 * <p>1.退款成功</p>
 * <pre><code class='json'>
 *  {
 *      "result_code": "200",
 *      "biz_response": {
 *          "result_code": "REFUND_SUCCESS",
 *          "data": {
 *              "sn": "7894259244067218",
 *              "client_sn": "12345677767776",
 *              "status": "SUCCESS",
 *              "payway": "3",
 *              "sub_payway": "1",
 *              "order_status": "REFUNDED",
 *              "trade_no": "2006101016201512080095793262",
 *              "total_amount": "1",
 *              "net_amount": "0",
 *              "finish_time": "1449563206776",
 *              "channel_finish_time": "1449563206632"
 *          }
 *      }
 *  }
 * </code></pre>
 *
 * <p>2.退款失败</p>
 * <pre><code class='json'>
 * {
 *      "result_code": "200",
 *      "biz_response": {
 *          "result_code": "FAIL",
 *          "error_code": "UPAY_REFUND_INVALID_ORDER_STATE",
 *          "error_message": "订单已全额退款,可退金额不足"
 *      }
 *  }
 * </code></pre>
 *
 * @author eric.hao
 * @since 2023/11/28
 */
@Data
@ApiModel("退款")
public class ShouPayRefundRespVO {

    @ApiModelProperty("状态码")
    private String resultCode;

    @ApiModelProperty("错误码")
    private String errorCode;

    @ApiModelProperty("错误原因")
    private String errorMessage;

    @ApiModelProperty("退款详情")
    private ShouPayRefundDetailRespVO data;
}
