package com.elitesland.cbpl.unionpay.shoupay.domain.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2023/11/28
 */
@Data
@ApiModel("交易订单详情")
public class ShouPayTradeDetailRespVO {

    @ApiModelProperty("收钱吧终端号")
    private String terminalSn;

    /**
     * 收钱吧系统内部唯一订单号
     */
    @ApiModelProperty("收钱吧唯一订单号")
    private String sn;

    @ApiModelProperty("商户订单号")
    private String clientSn;

    /**
     * 支付通道交易凭证号，只有支付成功时才有值返回
     */
    @ApiModelProperty("支付服务商订单号")
    private String tradeNo;

    /**
     * 本次操作产生的流水的状态
     */
    @ApiModelProperty("流水状态")
    private String status;

    @ApiModelProperty("订单状态")
    private String orderStatus;

    /**
     * 一级支付方式，取值见附录《支付方式列表》
     */
    @ApiModelProperty("支付方式")
    private String payway;

    @ApiModelProperty("支付方式名称")
    private String paywayName;

    /**
     * 二级支付方式，取值见附录《二级支付方式列表》
     */
    @ApiModelProperty("二级支付方式")
    private String subPayway;

    /**
     * 支付平台（微信，支付宝）上的付款人ID
     */
    @ApiModelProperty("付款人ID")
    private String payerUid;

    /**
     * 支付平台上(微信，支付宝)的付款人账号
     */
    @ApiModelProperty("付款人账号")
    private String payerLogin;

    @ApiModelProperty("交易总额")
    private String totalAmount;

    /**
     * 如果没有退款，这个字段等于total_amount。否则等于 total_amount减去退款金额
     */
    @ApiModelProperty("实收金额")
    private String netAmount;

    @ApiModelProperty("本次操作金额")
    private String settlementAmount;

    @ApiModelProperty("交易概述")
    private String subject;

    /**
     * 时间戳，只有order_status为最终状态时才会返回	"1449646835244"
     */
    @ApiModelProperty("付款动作在收钱吧的完成时间")
    private String finishTime;

    /**
     * 时间戳，只有支付成功时才有值返回	"1449646835244"
     */
    @ApiModelProperty("付款动作在支付服务商的完成时间")
    private String channelFinishTime;

    @ApiModelProperty("门店操作员")
    private String operator;

    @ApiModelProperty("透传参数")
    private String reflect;

    /**
     * 格式为json，内容有两部分：
     * <li>goods_details为数组，内容为核销单品信息</li>
     * <li>voucher_details为数组，内容为核销券信息</li>
     * <li>详见优惠详情：https://doc.shouqianba.com/zh-cn/api/interface/优惠详情.html</li>
     */
    @ApiModelProperty("优惠详情")
    private Object providerResponse;

    /**
     * 订单内活动优惠信息概览
     * <li>详见活动优惠：https://doc.shouqianba.com/zh-cn/api/interface/活动优惠.html</li>
     */
    @ApiModelProperty("活动优惠")
    private Object paymentList;
}
