/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unionpay.shoupay.cache;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.unionpay.shoupay.cache.ShouPayDeviceVO;
import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayDeviceService;
import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayVendorService;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayVendorQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayDeviceDetailVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayVendorRespVO;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ShouPayCache {
    private static final Logger logger = LoggerFactory.getLogger(ShouPayCache.class);
    private Map<String, ShouPayDeviceVO> devices;
    private final ShouPayVendorService vendorService;
    private final ShouPayDeviceService deviceService;

    @PostConstruct
    public void init() {
        logger.info("[PHOENIX-UNIONPAY] load devices.");
    }

    public ShouPayDeviceVO get(String deviceId) {
        ShouPayDeviceVO device = this.queryByDeviceId(deviceId);
        if (ObjectUtil.isNull((Object)device)) {
            throw new IllegalArgumentException("[PHOENIX-UNIONPAY] deviceId(" + deviceId + ") not found.");
        }
        return device;
    }

    @Deprecated
    private ShouPayDeviceVO queryByDeviceId(String deviceId) {
        ShouPayVendorQueryParamVO vendorQuery = new ShouPayVendorQueryParamVO();
        vendorQuery.setDefaultFlag(1);
        vendorQuery.setDeleteFlag(0);
        List<ShouPayVendorRespVO> vendors = this.vendorService.shouPayVendorByParam(vendorQuery);
        if (CollUtil.isEmpty(vendors)) {
            throw new IllegalArgumentException("[PHOENIX-UNIONPAY] vendors default environment not found.");
        }
        if (vendors.size() > 1) {
            throw new IllegalArgumentException("[PHOENIX-UNIONPAY] vendors have multiple default environment.");
        }
        ShouPayDeviceDetailVO device = this.deviceService.shouPayDeviceById(deviceId);
        ShouPayDeviceVO deviceVO = new ShouPayDeviceVO();
        deviceVO.setVendorSn(vendors.get(0).getVendorSn());
        deviceVO.setVendorKey(vendors.get(0).getVendorKey());
        deviceVO.setAppId(vendors.get(0).getAppId());
        deviceVO.setEnvironment(vendors.get(0).getEnvironment());
        deviceVO.setApiDomain(vendors.get(0).getApiDomain());
        deviceVO.setSdkVersion(vendors.get(0).getSdkVersion());
        deviceVO.setDeviceId(device.getDeviceId());
        deviceVO.setDeviceName(device.getDeviceName());
        deviceVO.setClientSn(device.getClientSn());
        deviceVO.setActivateCode(device.getActivateCode());
        deviceVO.setTerminalSn(device.getTerminalSn());
        deviceVO.setTerminalKey(device.getTerminalKey());
        deviceVO.setLastUpdateTime(device.getLastUpdateTime());
        return deviceVO;
    }

    public Map<String, ShouPayDeviceVO> getDevices() {
        return this.devices;
    }

    public ShouPayVendorService getVendorService() {
        return this.vendorService;
    }

    public ShouPayDeviceService getDeviceService() {
        return this.deviceService;
    }

    public void setDevices(Map<String, ShouPayDeviceVO> devices) {
        this.devices = devices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShouPayCache)) {
            return false;
        }
        ShouPayCache other = (ShouPayCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ShouPayDeviceVO> this$devices = this.getDevices();
        Map<String, ShouPayDeviceVO> other$devices = other.getDevices();
        if (this$devices == null ? other$devices != null : !((Object)this$devices).equals(other$devices)) {
            return false;
        }
        ShouPayVendorService this$vendorService = this.getVendorService();
        ShouPayVendorService other$vendorService = other.getVendorService();
        if (this$vendorService == null ? other$vendorService != null : !this$vendorService.equals(other$vendorService)) {
            return false;
        }
        ShouPayDeviceService this$deviceService = this.getDeviceService();
        ShouPayDeviceService other$deviceService = other.getDeviceService();
        return !(this$deviceService == null ? other$deviceService != null : !this$deviceService.equals(other$deviceService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShouPayCache;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ShouPayDeviceVO> $devices = this.getDevices();
        result = result * 59 + ($devices == null ? 43 : ((Object)$devices).hashCode());
        ShouPayVendorService $vendorService = this.getVendorService();
        result = result * 59 + ($vendorService == null ? 43 : $vendorService.hashCode());
        ShouPayDeviceService $deviceService = this.getDeviceService();
        result = result * 59 + ($deviceService == null ? 43 : $deviceService.hashCode());
        return result;
    }

    public String toString() {
        return "ShouPayCache(devices=" + this.getDevices() + ", vendorService=" + this.getVendorService() + ", deviceService=" + this.getDeviceService() + ")";
    }

    public ShouPayCache(ShouPayVendorService vendorService, ShouPayDeviceService deviceService) {
        this.vendorService = vendorService;
        this.deviceService = deviceService;
    }
}

