/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unionpay.shoupay.proxy;

import cn.hutool.system.SystemUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.unionpay.shoupay.cache.ShouPayCache;
import com.elitesland.cbpl.unionpay.shoupay.cache.ShouPayDeviceVO;
import com.elitesland.cbpl.unionpay.shoupay.common.util.HttpUtil;
import com.elitesland.cbpl.unionpay.shoupay.domain.base.ShouPayRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayCancelParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayRefundParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayTerminalParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayTradeParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayCancelRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayQueryRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayRefundRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayTerminalRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayTradeRespVO;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Validated
@Component
public class ShouPayProxy {
    private static final Logger logger = LoggerFactory.getLogger(ShouPayProxy.class);
    private final ShouPayCache shouPayCache;

    public ShouPayRespVO<ShouPayTerminalRespVO> activate(@NotBlank String deviceId) {
        ShouPayDeviceVO device = this.shouPayCache.get(deviceId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", device.getAppId());
        params.put("code", device.getActivateCode());
        params.put("device_id", deviceId);
        params.put("client_sn", device.getClientSn());
        params.put("name", device.getDeviceName());
        params.put("os_info", SystemUtil.getOsInfo().getName());
        params.put("sdk_version", device.getSdkVersion());
        String url = device.getApiDomain() + "/terminal/activate";
        return HttpUtil.httpPost(url, params, device.getVendorKey(), device.getVendorSn(), ShouPayTerminalRespVO.class);
    }

    public ShouPayRespVO<ShouPayTerminalRespVO> checkin(@NotBlank String deviceId) {
        ShouPayDeviceVO device = this.shouPayCache.get(deviceId);
        return this.terminalPost(deviceId, "/terminal/checkin", ShouPayTerminalParamVO.checkin(device), ShouPayTerminalRespVO.class);
    }

    private void checkTerminalKey(String deviceId) {
        ShouPayDeviceVO device = this.shouPayCache.get(deviceId);
        if (device.needCheckin()) {
            this.checkin(deviceId);
        }
    }

    public ShouPayRespVO<ShouPayTradeRespVO> pay(@NotBlank String deviceId, @Valid ShouPayTradeParamVO paramVO) {
        return this.terminalCheckPost(deviceId, "/upay/v2/pay", paramVO, ShouPayTradeRespVO.class);
    }

    public ShouPayRespVO<ShouPayRefundRespVO> refund(@NotBlank String deviceId, @Valid ShouPayRefundParamVO paramVO) {
        return this.terminalCheckPost(deviceId, "/upay/v2/refund", paramVO, ShouPayRefundRespVO.class);
    }

    public ShouPayRespVO<ShouPayQueryRespVO> query(@NotBlank String deviceId, @Valid ShouPayQueryParamVO paramVO) {
        return this.terminalCheckPost(deviceId, "/upay/v2/query", paramVO, ShouPayQueryRespVO.class);
    }

    public ShouPayRespVO<ShouPayCancelRespVO> cancel(@NotBlank String deviceId, @Valid ShouPayCancelParamVO paramVO) {
        return this.terminalCheckPost(deviceId, "/upay/v2/cancel", paramVO, ShouPayCancelRespVO.class);
    }

    public ShouPayRespVO<ShouPayCancelRespVO> revoke(@NotBlank String deviceId, @Valid ShouPayCancelParamVO paramVO) {
        return this.terminalCheckPost(deviceId, "/upay/v2/revoke", paramVO, ShouPayCancelRespVO.class);
    }

    private <T> ShouPayRespVO<T> terminalCheckPost(String deviceId, String url, Object paramVO, Class<T> clazz) {
        this.checkTerminalKey(deviceId);
        return this.terminalPost(deviceId, url, paramVO, clazz);
    }

    private <T> ShouPayRespVO<T> terminalPost(String deviceId, String url, Object paramVO, Class<T> clazz) {
        ShouPayDeviceVO device = this.shouPayCache.get(deviceId);
        Map<String, Object> params = HttpUtil.paramToMap(paramVO);
        params.put("terminal_sn", device.getTerminalSn());
        ShouPayRespVO<T> result = HttpUtil.httpPost(device.getApiDomain() + url, params, device.getTerminalKey(), device.getTerminalSn(), clazz);
        if (result.fail()) {
            logger.error("[PHOENIX-UNIONPAY][SHOUPAY-ERROR] request failed: deviceId({}), url({}).", (Object)deviceId, (Object)url);
        }
        logger.debug("[PHOENIX-UNIONPAY][SHOUPAY-DEBUG] request url({}), result: {}", (Object)url, (Object)BeanUtils.toJsonStr(result));
        return result;
    }

    public ShouPayProxy(ShouPayCache shouPayCache) {
        this.shouPayCache = shouPayCache;
    }
}

