package com.elitesland.cbpl.unionpay.shoupay.data.controller;

import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayDeviceSaveParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayDeviceService;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayDeviceQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayDeviceDetailVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayDeviceRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayTerminalRespVO;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
@Slf4j
@Api(tags = "收钱吧 - 收银终端设备")
@ApiSupport(author = "eric.hao", order = 2)
@RestController
@RequestMapping("/unionpay/shoupay/device")
@AllArgsConstructor
public class ShouPayDeviceController {

    private final ShouPayDeviceService shouPayDeviceService;

    @ApiOperation(value = "不分页查询")
    @PostMapping(value = "/query")
    public List<ShouPayDeviceRespVO> query(@RequestBody ShouPayDeviceQueryParamVO query) {
        logger.info("[PHOENIX-UNIONPAY] query list param = {}", query);
        return shouPayDeviceService.shouPayDeviceByParam(query);
    }

    @ApiOperation(value = "明细查询")
    @GetMapping(value = "/detail/{deviceId}")
    public ShouPayDeviceDetailVO detail(@PathVariable("deviceId") String deviceId) {
        logger.info("[PHOENIX-UNIONPAY] query detail by deviceId = {}", deviceId);
        return shouPayDeviceService.shouPayDeviceById(deviceId);
    }

    @ApiOperation(value = "新增或修改")
    @PostMapping(value = "/save")
    public Long save(@RequestBody ShouPayDeviceSaveParamVO saveParam) {
        logger.info("[PHOENIX-UNIONPAY] create/update record, saveParam = {}", saveParam);
        return shouPayDeviceService.save(saveParam);
    }

    @ApiOperation(value = "设备激活")
    @PutMapping(value = "/{deviceId}/activate")
    public ShouPayTerminalRespVO activate(@PathVariable("deviceId") String deviceId) {
        logger.info("[PHOENIX-UNIONPAY] activate deviceId = {}", deviceId);
        return shouPayDeviceService.activate(deviceId);
    }

    @ApiOperation(value = "手动签到")
    @PutMapping(value = "/{deviceId}/checkin")
    public ShouPayTerminalRespVO checkin(@PathVariable("deviceId") String deviceId) {
        logger.info("[PHOENIX-UNIONPAY] checkin deviceId = {}", deviceId);
        return shouPayDeviceService.checkin(deviceId);
    }
}
