package com.elitesland.cbpl.unionpay.shoupay.data.convert;

import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayDeviceSaveParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.entity.ShouPayDeviceDO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayDeviceDetailVO;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2023/11/27
 */
@Mapper(config = BaseMapperConfig.class)
public interface ShouPayDeviceConvert {

	ShouPayDeviceConvert INSTANCE = Mappers.getMapper(ShouPayDeviceConvert.class);

    /**
     * DO => RespVO
     */
    ShouPayDeviceDetailVO doToVO(ShouPayDeviceDO shouPayDeviceDO);

    /**
     * SaveParam => DO
     */
    ShouPayDeviceDO saveParamToDO(ShouPayDeviceSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(ShouPayDeviceSaveParamVO saveParam, @MappingTarget ShouPayDeviceDO shouPayDeviceDO);
}
