package com.elitesland.cbpl.unionpay.shoupay.data.repo;

import com.elitesland.cbpl.unionpay.shoupay.data.entity.ShouPayDeviceDO;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
public interface ShouPayDeviceRepo extends JpaRepository<ShouPayDeviceDO, Long>, QuerydslPredicateExecutor<ShouPayDeviceDO> {

    /**
     * 根据设备号，获取设备信息
     *
     * @param deviceId 设备号
     * @return 设备信息
     */
    Optional<ShouPayDeviceDO> findByDeviceId(String deviceId);
}
