package com.elitesland.cbpl.unionpay.shoupay.data.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.unionpay.shoupay.data.entity.QShouPayDeviceDO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayDeviceQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayDeviceRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayTerminalRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
@Component
@RequiredArgsConstructor
public class ShouPayDeviceRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QShouPayDeviceDO shouPayDeviceDO = QShouPayDeviceDO.shouPayDeviceDO;

    private final QBean<ShouPayDeviceRespVO> shouPayDeviceVO = Projections.bean(
            ShouPayDeviceRespVO.class,
            shouPayDeviceDO.id,
            shouPayDeviceDO.deviceId,
            shouPayDeviceDO.deviceName,
            shouPayDeviceDO.clientSn,
            shouPayDeviceDO.activateCode,
            shouPayDeviceDO.terminalSn,
            shouPayDeviceDO.terminalKey,
            shouPayDeviceDO.lastUpdateTime,
            shouPayDeviceDO.deleteFlag,
            shouPayDeviceDO.createTime,
            shouPayDeviceDO.modifyTime
    );

    private Predicate where(ShouPayDeviceQueryParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(shouPayDeviceDO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(query.getId())) {
            predicates.add(shouPayDeviceDO.id.eq(query.getId()));
        }
        if (StrUtil.isNotBlank(query.getDeviceId())) {
            predicates.add(shouPayDeviceDO.deviceId.eq(query.getDeviceId()));
        }
        if (StrUtil.isNotBlank(query.getDeviceName())) {
            predicates.add(shouPayDeviceDO.deviceName.eq(query.getDeviceName()));
        }
        if (StrUtil.isNotBlank(query.getClientSn())) {
            predicates.add(shouPayDeviceDO.clientSn.eq(query.getClientSn()));
        }
        if (StrUtil.isNotBlank(query.getActivateCode())) {
            predicates.add(shouPayDeviceDO.activateCode.eq(query.getActivateCode()));
        }
        if (StrUtil.isNotBlank(query.getTerminalSn())) {
            predicates.add(shouPayDeviceDO.terminalSn.eq(query.getTerminalSn()));
        }
        if (StrUtil.isNotBlank(query.getTerminalKey())) {
            predicates.add(shouPayDeviceDO.terminalKey.eq(query.getTerminalKey()));
        }
        if (ObjectUtil.isNotNull(query.getLastUpdateTime())) {
            predicates.add(shouPayDeviceDO.lastUpdateTime.eq(query.getLastUpdateTime()));
        }
        if (ObjectUtil.isNotNull(query.getDeleteFlag())) {
            predicates.add(shouPayDeviceDO.deleteFlag.eq(query.getDeleteFlag()));
        }
        if (ObjectUtil.isNotNull(query.getCreateTime())) {
            predicates.add(shouPayDeviceDO.createTime.eq(query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull(query.getModifyTime())) {
            predicates.add(shouPayDeviceDO.modifyTime.eq(query.getModifyTime()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ShouPayDeviceRespVO> shouPayDeviceByParam(ShouPayDeviceQueryParamVO query) {
        JPAQuery<ShouPayDeviceRespVO> jpaQuery = jpaQueryFactory.select(shouPayDeviceVO)
                .from(shouPayDeviceDO);
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    /**
     * 更新设备激活信息
     *
     * @param deviceId 设备号
     * @param terminal 设备信息
     */
    public long updateTerminal(String deviceId, ShouPayTerminalRespVO terminal) {
        JPAUpdateClause update = jpaQueryFactory.update(shouPayDeviceDO)
                .set(shouPayDeviceDO.terminalSn, terminal.getTerminalSn())
                .set(shouPayDeviceDO.terminalKey, terminal.getTerminalKey())
                .set(shouPayDeviceDO.lastUpdateTime, LocalDateTime.now())
                .where(shouPayDeviceDO.deviceId.eq(deviceId));
        return update.execute();
    }
}
