package com.elitesland.cbpl.unionpay.shoupay.data.service;

import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayDeviceSaveParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayDeviceQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayDeviceDetailVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayDeviceRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayTerminalRespVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
public interface ShouPayDeviceService {

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<ShouPayDeviceRespVO> shouPayDeviceByParam(ShouPayDeviceQueryParamVO query);

    /**
     * 明细查询
     *
     * @param deviceId 设备号
     * @return 明细数据
     */
    ShouPayDeviceDetailVO shouPayDeviceById(String deviceId);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(ShouPayDeviceSaveParamVO saveParam);

    /**
     * 设备激活
     *
     * @param deviceId 设备号
     * @return 设备信息
     */
    ShouPayTerminalRespVO activate(String deviceId);

    /**
     * 手动签到
     *
     * @param deviceId 设备号
     * @return 设备信息
     */
    ShouPayTerminalRespVO checkin(String deviceId);
}
