package com.elitesland.cbpl.unionpay.shoupay.domain.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * <strong>请求示例：</strong>
 * <pre><code class='json'>
 * {
 *     "total_amount": "1",
 *     "subject": "收钱吧",
 *     "dynamic_id": "281234305112341234",
 *     "operator": "Roy",
 *     "terminal_sn": "100003612347111234",
 *     "client_sn": "8529061153479888",
 *     "extended": {
 *         "extend_params": {
 *             "hb_fq_seller_percent": "0",
 *             "hb_fq_num": "12"
 *         }
 *     }
 * }
 * </code></pre>
 *
 * @author eric.hao
 * @since 2023/11/28
 */
@Data
@ApiModel("交易订单")
public class ShouPayTradeParamVO {

    @NotBlank(message = "收钱吧终端号不能为空")
    @Size(max = 32, message = "收钱吧终端号不能超过32位")
    @ApiModelProperty("收钱吧终端号")
    private String terminalSn;

    /**
     * 必须在商户系统内唯一
     */
    @NotBlank(message = "平台订单号不能为空")
    @Size(max = 32, message = "平台订单号不能超过32位")
    @ApiModelProperty("商户系统订单号")
    private String clientSn;

    /**
     * 以分为单位, 不超过10位纯数字字符串, 超过1亿元的收款请使用银行转账
     */
    @NotBlank(message = "交易总金额不能为空")
    @ApiModelProperty("交易总金额")
    private String totalAmount;

    /**
     * 内容为数字的字符串。一旦设置，则根据支付码判断支付通道的逻辑失效
     * <li>1:支付宝、3:微信、4:百度钱包、5:京东钱包、6:qq钱包</li>
     */
    @ApiModelProperty("支付方式")
    private String payway;

    @NotBlank(message = "条码内容不能为空")
    @Size(max = 32, message = "条码内容不能超过32位")
    @ApiModelProperty("条码内容")
    private String dynamicId;

    @NotBlank(message = "交易简介不能为空")
    @ApiModelProperty("交易简介")
    private String subject;

    @NotBlank(message = "门店操作员不能为空")
    @ApiModelProperty("门店操作员")
    private String operator;

    /**
     * 对商品或本次交易的描述
     */
    @ApiModelProperty("商品详情")
    private String description;

    /**
     * 经纬度必须同时出现	"121.615459404"
     */
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 经纬度必须同时出现	"31.4056441552"
     */
    @ApiModelProperty("维度")
    private String latitude;

    @ApiModelProperty("设备指纹")
    private String deviceId;

    /**
     * 收钱吧与特定第三方单独约定的参数集合, json格式, 最多支持24个字段
     * 每个字段key长度不超过64字节, value长度不超过256字节	{ "goods_tag": "beijing"}
     */
    @ApiModelProperty("扩展参数集合")
    private Object extended;

    @ApiModelProperty("商品详情")
    private List<ShouPayGoodParamVO> goodsDetails;

    /**
     * 任何调用者希望原样返回的信息，可以用于关联商户ERP系统的订单或记录附加订单内容
     * <li>json字符串, "{ \"tips\": \"200\" }"</li>
     */
    @ApiModelProperty("反射参数")
    private Object reflect;

    /**
     * 例如：www.baidu.com 如果支付成功通知时间间隔为1s,5s,30s,600s
     */
    @ApiModelProperty("支付回调的地址")
    private String notifyUrl;
}
